unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Buttons;

type
  TMainForm = class(TForm)
    Panel2: TPanel;
    btnCLOSE: TBitBtn;
    ScrollBox: TScrollBox;
    PaintBox: TPaintBox;
    procedure PaintBoxPaint(Sender: TObject);
    procedure ScrollBoxResize(Sender: TObject);
    procedure btnCLOSEClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);

  private

  public
    Lines : TStringList;

	 procedure Ustaw_komponenty();
    procedure Wczytaj_plik();
    procedure Wyswietl_plik();
  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.btnCLOSEClick(Sender: TObject);
begin
	Close();
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	if Assigned(Lines) then
   begin
		Lines.Clear();
      FreeAndNil(Lines);
   end;

   Action := caFree;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
   Wczytaj_plik();
	Ustaw_komponenty();
end;

procedure TMainForm.PaintBoxPaint(Sender: TObject);
begin
	Wyswietl_plik();
end;

procedure TMainForm.ScrollBoxResize(Sender: TObject);
begin
	Wyswietl_plik();
end;

procedure TMainForm.Wczytaj_plik();
var
	fn      : String;

begin
	Lines := TStringList.Create();

	fn     := 'License.txt';

   if FileExists(fn) then
   begin
      Lines.LoadFromFile(fn);
   end;
end;

procedure TMainForm.Wyswietl_plik();
var
	x       : Integer;
   y       : Integer;
	lp      : Integer;
   wiersz  : String;

begin
   if Lines.Count > 0 then
   begin
      x := 5;
      y := 5;

      // wypisz tekst z pliku na ekranie
      for lp := 0 to Lines.Count-1 do
      begin
      	wiersz := Trim(Lines[lp]);

         PaintBox.Canvas.TextOut(x, y, wiersz);

         y := y + PaintBox.Canvas.TextHeight(wiersz);
      end;
   end;
end;

procedure TMainForm.Ustaw_komponenty();
var
	szer : Integer;
   wys  : Integer;

begin
   ScrollBox.Align := alClient;

	szer := Screen.Width;
   wys  := Screen.Height;

   // licz na ile trzeba ustawi wysoko PaintBox
	wys := PaintBox.Canvas.TextHeight(Lines[0]);
   wys := (wys * Lines.Count);

   PaintBox.Width  := szer;
   PaintBox.Height := wys;
end;

end.

